;Message format:
;0-95: 		print character
;96-126:	followed by another byte: address to print to, once 32 has been extracted from the first byte (that is the high part)
;			Therefore, 32+64 = first third, 32+64+8 = second third, and 32+64+16 = third third.
;			and the following byte is usually expressed as: line*32+column
;127: 		end message
;128-255: 	attribute code (withoutflash), followed by a byte indicating number of repetitions

marker_message:		defb	32+64
message_pos1st:		defb	1*32+17		;fixed!
message_col1st:		defb	0,6		;lenght fixed
			defb	0,0,0,0,0,0
			defb	32+64
message_pos2nd:		defb	2*32+17
message_col2nd:		defb	0,6		;lenght fixed
			defb	0,0,0,0,0,0
			defb	32+64
message_pos3rd:		defb	3*32+17
message_col3rd:		defb	0,6		;lenght fixed
			defb	0,0,0,0,0,0
			defb	32+64
message_pos4th:		defb	4*32+17
message_col4th:		defb	0,6		;lenght fixed
			defb	0,0,0,0,0,0,32+64
message_black1:		defb	5*32+17
			defb	128,6,32+64
message_black2:		defb	6*32+17
			defb	128,6,32+64
message_black3:		defb	7*32+17
			defb	128,6
			defb	127
mes_mark_1st:		defb	CHR_W,CHR_I,CHR_N,CHR_N,CHR_E,CHR_R
mes_mark_2nd:		defb	CHR_S,CHR_E,CHR_C,CHR_O,CHR_N,CHR_D
mes_mark_3rd:		defb	CHR_T,CHR_H,CHR_I,CHR_R,CHR_D,CHR_SPACE
mes_mark_4th:		defb	CHR_L,CHR_O,CHR_S,CHR_E,CHR_R,CHR_EXCL
mes_mt_color:		defb	0,6
mes_mt_m10:		defb	CHR_PLUS
mes_mt_m1:		defb	0
mes_mt_s10:		defb	0
mes_mt_s1:		defb	0,CHR_POINT
mes_mt_d:		defb	0
			defb	127
mes_points_col:		defb	128,3
mes_points:		defb	0
mes_extrapoints:	defb	CHR_SPACE
			defb	CHR_SPACE
			defb	127

mes_mark_lapch:		defb	CHR_L
mes_ml_lap:		defb	0
			defb	CHR_MINUS	;
			defb	CHR_C
			defb	CHR_H
					;mes_ml_ch10:	defb	0
mes_ml_ch1:		defb	0
mes_mt_toomuch:		defb	CHR_MINUS,CHR_MINUS,CHR_MINUS,CHR_MINUS,CHR_MINUS,CHR_MINUS

mmenu_fixed:		defb	32+64,4*32+2,128+3,16,CHR_1,32+64,4*32+19,CHR_E,CHR_X,CHR_T,CHR_R,CHR_A,CHR_SPACE,CHR_K,CHR_E,CHR_Y,CHR_S,CHR_COLON
			defb	32+64,5*32+2,128+1,16,CHR_2
			defb	32+64,6*32+2,128+5,16,CHR_3,32+64,6*32+25,CHR_P,CHR_A,CHR_U,CHR_S,CHR_E
			defb	32+64,7*32+2,128+6,16,CHR_4,32+64,7*32+25,CHR_S,CHR_O,CHR_U,CHR_N,CHR_D
			defb	32+64+8,0*32+25,CHR_C,CHR_A,CHR_M,CHR_SPACE,CHR_1
			defb	32+64+8,1*32+2,CHR_5,CHR_SPACE,CHR_R,CHR_E,CHR_D,CHR_E,CHR_F,CHR_I,CHR_N,CHR_E
			defb	32+64+8,1*32+25,CHR_C,CHR_A,CHR_M,CHR_SPACE,CHR_2
			defb	32+64+8,6*32+2,128+4,32,CHR_8,CHR_SPACE,CHR_P,CHR_E,CHR_R,CHR_S,CHR_O,CHR_N,CHR_A,CHR_L,CHR_I,CHR_Z,CHR_E
			defb	32+64+8,3*32+2,128+2,32,CHR_6,CHR_SPACE,CHR_C,CHR_A,CHR_T,CHR_E,CHR_G,CHR_O,CHR_R,CHR_Y,CHR_COLON,CHR_SPACE
mmenu_category:		defb	CHR_J,CHR_U,CHR_N,CHR_I,CHR_O,CHR_R
			defb	32+64+8,5*32+2,128+4,32,CHR_7,CHR_SPACE,CHR_C,CHR_H,CHR_A,CHR_M,CHR_P,CHR_I,CHR_O,CHR_N,CHR_S,CHR_H,CHR_I,CHR_P,CHR_COLON,CHR_SPACE
mmenu_champion:		defb	CHR_E,CHR_A,CHR_S,CHR_Y,CHR_SPACE,CHR_SPACE,CHR_SPACE,CHR_SPACE,CHR_SPACE,CHR_SPACE
			defb	32+64,6*32+23
mmenu_keypause:		defb	CHR_T
			defb	32+64,7*32+23
mmenu_keysound:		defb	CHR_Y
			defb	32+64+8,0*32+23
mmenu_keycam1:		defb	CHR_F
			defb	32+64+8,1*32+23
mmenu_keycam2:		defb	CHR_G
			defb	127
mmenu_0start:		defb	32+64+16,2*32+10,CHR_0,CHR_SPACE,CHR_S,CHR_T,CHR_A,CHR_R,CHR_T,CHR_SPACE,CHR_G,CHR_A,CHR_M,CHR_E

mmenu_noredefine:	defb	32+64+8,2*32+4,CHR_SPACE,CHR_SPACE,CHR_SPACE,CHR_SPACE,CHR_SPACE,CHR_SPACE,CHR_SPACE,CHR_SPACE
			defb	CHR_SPACE,CHR_SPACE,CHR_SPACE,CHR_SPACE,CHR_SPACE,CHR_SPACE,CHR_SPACE,CHR_SPACE,127

mmenu_keys1:		defb	CHR_K,CHR_E,CHR_Y,CHR_S,CHR_COLON						;0
mmenu_keys1_def:	defb	CHR_P,CHR_O,CHR_Q,CHR_A
			defb	CHR_SPACE,127
mmenu_keys2:		defb	CHR_K,CHR_E,CHR_Y,CHR_S,CHR_COLON						;1
mmenu_keys2_def:	defb	CHR_R,CHR_E,CHR_W,CHR_S
			defb	CHR_SPACE,127
mmenu_keys3:		defb	CHR_K,CHR_E,CHR_Y,CHR_S,CHR_COLON						;2
mmenu_keys3_def:	defb	CHR_L,CHR_K,CHR_H,CHR_N
			defb	CHR_SPACE,127
mmenu_sinc1:		defb	CHR_S,CHR_I,CHR_N,CHR_C,CHR_L,CHR_A,CHR_I,CHR_R,CHR_SPACE,CHR_1,127		;3
mmenu_sinc2:		defb	CHR_S,CHR_I,CHR_N,CHR_C,CHR_L,CHR_A,CHR_I,CHR_R,CHR_SPACE,CHR_2,127		;4
mmenu_kempston:		defb	CHR_K,CHR_E,CHR_M,CHR_P,CHR_S,CHR_T,CHR_O,CHR_N,CHR_SPACE,CHR_SPACE,127		;5
mmenu_cpu1:		defb	CHR_C,CHR_P,CHR_U,CHR_SPACE,CHR_E,CHR_A,CHR_S,CHR_Y,CHR_SPACE,CHR_SPACE,127	;6
mmenu_cpu2:		defb	CHR_C,CHR_P,CHR_U,CHR_SPACE,CHR_N,CHR_O,CHR_R,CHR_M,CHR_A,CHR_L,127		;7
mmenu_cpu3:		defb	CHR_C,CHR_P,CHR_U,CHR_SPACE,CHR_H,CHR_A,CHR_R,CHR_D,CHR_SPACE,CHR_SPACE,127	;8
mmenu_nobody:		defb	CHR_D,CHR_O,CHR_NAPOST,CHR_T,CHR_SPACE,CHR_R,CHR_A,CHR_C,CHR_E,CHR_SPACE,127	;9

mmenu_keyfor:		defb	32+64+8,2*32+6,CHR_K,CHR_E,CHR_Y,CHR_SPACE,CHR_F,CHR_O,CHR_R,127

mmenu_rede_right:	defb	CHR_R,CHR_I,CHR_G,CHR_H,CHR_T,CHR_INTERR,127
mmenu_rede_left:	defb	CHR_L,CHR_E,CHR_F,CHR_T,CHR_INTERR,CHR_SPACE,127
mmenu_rede_up:		defb	CHR_U,CHR_P,CHR_INTERR,CHR_SPACE,CHR_SPACE,CHR_SPACE,127
mmenu_rede_down:	defb	CHR_D,CHR_O,CHR_W,CHR_N,CHR_INTERR,CHR_SPACE,127
mmenu_rede_pause:	defb	CHR_P,CHR_A,CHR_U,CHR_S,CHR_E,CHR_INTERR,127
			defb	CHR_S,CHR_O,CHR_U,CHR_N,CHR_D,CHR_INTERR,127
			defb	CHR_C,CHR_A,CHR_M,CHR_SPACE,CHR_1,CHR_INTERR,127
			defb	CHR_C,CHR_A,CHR_M,CHR_SPACE,CHR_2,CHR_INTERR,127

mpause_pause:		defb	32+64+8,2*32+13,128+15,6,CHR_P,CHR_A,CHR_U,CHR_S,CHR_E,CHR_SPACE
			defb	32+64+8,3*32+13,128+9,6
			defb	32+64+8,4*32+13,128+15,6,CHR_P,CHR_R,CHR_E,CHR_S,CHR_S,CHR_SPACE
			defb	32+64+8,5*32+13,128+15,6,CHR_QUOTES,CHR_A,CHR_QUOTES,CHR_SPACE,CHR_T,CHR_O
			defb	32+64+8,6*32+13,128+15,6,CHR_SPACE,CHR_A,CHR_B,CHR_O,CHR_R,CHR_T
			defb	127
mpause_abort:		defb	32+64+8,2*32+13,128+15,6,CHR_A,CHR_B,CHR_O,CHR_R,CHR_T,CHR_INTERR
			defb	32+64+8,3*32+13,128+15,6,CHR_N,CHR_COLON,CHR_B,CHR_A,CHR_C,CHR_K
			defb	32+64+8,4*32+13,128+15,6,CHR_Y,CHR_COLON,CHR_M,CHR_E,CHR_N,CHR_U
			defb	32+64+8,5*32+13,128+15,6,CHR_T,CHR_COLON,CHR_N,CHR_E,CHR_X,CHR_T
			defb	32+64+8,6*32+13,128+15,6,CHR_SPACE,CHR_T,CHR_R,CHR_A,CHR_C,CHR_K
			defb	127
tr_trackres:		defb	32+64,9,CHR_T,CHR_R,CHR_A,CHR_C,CHR_K,CHR_SPACE,CHR_R,CHR_E,CHR_S,CHR_U,CHR_L,CHR_T,CHR_S
			defb	32+64,2*32,CHR_T,CHR_O,CHR_T,CHR_A,CHR_L,CHR_SPACE,CHR_T,CHR_I,CHR_M,CHR_E
			defb	32+64,2*32+15,CHR_B,CHR_E,CHR_S,CHR_T,CHR_SPACE,CHR_L,CHR_A,CHR_P
			defb	32+64,2*32+26,CHR_P,CHR_O,CHR_I,CHR_N,CHR_T,CHR_S
			defb	32+64+16,1*32,CHR_C,CHR_L,CHR_A,CHR_S,CHR_S,CHR_I,CHR_F,CHR_I,CHR_C,CHR_A,CHR_T,CHR_I,CHR_O,CHR_N
			defb	32+64+16,1*32+19
tr_col1:		defb	131
			defb	6
tr_pos1:		defb	CHR_1,CHR_SPACE,CHR_MINUS,CHR_SPACE
tr_points1:		defb	CHR_0,CHR_0
			defb	32+64+16,2*32+19
tr_col2:		defb	131
			defb	6
tr_pos2:		defb	CHR_1,CHR_SPACE,CHR_MINUS,CHR_SPACE
tr_points2:		defb	CHR_0,CHR_0
			defb	32+64+16,3*32+19
tr_col3:		defb	131
			defb	6
tr_pos3:		defb	CHR_1,CHR_SPACE,CHR_MINUS,CHR_SPACE
tr_points3:		defb	CHR_0,CHR_0
			defb	32+64+16,4*32+19
tr_col4:		defb	131
			defb	6
tr_pos4:		defb	CHR_1,CHR_SPACE,CHR_MINUS,CHR_SPACE
tr_points4:		defb	CHR_0,CHR_0
			defb	127
tr_presskey:		defb	32+64+16,7*32+7,CHR_A,CHR_N,CHR_Y,CHR_SPACE,CHR_K,CHR_E,CHR_Y,CHR_SPACE,CHR_T,CHR_O,CHR_SPACE,CHR_C,CHR_O,CHR_N,CHR_T,CHR_I,CHR_N,CHR_U,CHR_E
			defb	127

mmenu_cat0:		defb	CHR_F,CHR_1,CHR_SPACE,CHR_SPACE,CHR_SPACE,CHR_SPACE
			defb	CHR_G,CHR_P,CHR_2,CHR_SPACE,CHR_SPACE,CHR_SPACE
			defb	CHR_K,CHR_A,CHR_R,CHR_T,CHR_S,CHR_SPACE
			defb	CHR_J,CHR_U,CHR_N,CHR_I,CHR_O,CHR_R

end_podium:		defb	32+64+8,4*32+13,128+56,6
			defb	32+64+8,5*32+7,128+56,12
			defb	32+64+8,6*32+7,128+56,18,CHR_SPACE,CHR_SPACE,64+12,64+13
			defb	32+64+8,6*32+15,64+8,64+9
			defb	32+64+8,6*32+21,64+12,64+13
			defb	32+64+8,7*32+7,128+56,18,CHR_SPACE,CHR_SPACE,64+14,64+15
			defb	32+64+8,7*32+15,64+10,64+11
			defb	32+64+8,7*32+21,64+16,64+17
			defb	32+64+16,1*32+6,CHR_C,CHR_H,CHR_A,CHR_M,CHR_P,CHR_I,CHR_O,CHR_N,CHR_S,CHR_H,CHR_I,CHR_P,CHR_SPACE,CHR_I,CHR_S,CHR_SPACE,CHR_O,CHR_V,CHR_E,CHR_R
			defb	32+64+16,3*32+8,CHR_T,CHR_H,CHR_X,CHR_SPACE,CHR_F,CHR_O,CHR_R,CHR_SPACE,CHR_P,CHR_L,CHR_A,CHR_Y,CHR_I,CHR_N,CHR_G,CHR_EXCL
			defb	32+64+16,7*32+0,128,32
			defb	127		
end_pilot:		defb	32+64+8	;
end_pilotp1:		defb	0		;Line 1 	position
			defb	128+7,2	;		Color white
			defb	64,65,32+64+8	;		Chars
end_pilotp2:		defb	0		;Line 2 	position
			defb	128+7,2	;		Color white
			defb	66,67,32+64+8	;		Chars
end_pilotp3:		defb	0		;Line 3 	position
end_pilotc3a:		defb	0,1		;		Color
			defb	68		;		Char
end_pilotc3b:		defb	0,1		;		Color
			defb	69,32+64+8	;		Char
end_pilotp4:		defb	0		;Line 4	position
end_pilotc4a:		defb	0,1		;		Color nobright
			defb	70		;		Char
end_pilotc4b:		defb	0,1		;		Color bright
			defb	71		;		Char
			defb	127		
endg_n1:		defb	0
			defb	0*32+16
endg_n2:		defb	0
			defb	1*32+10
endg_n3:		defb	0
			defb	2*32+22
mpers_init:		defb	32+64+0,3*32+4,CHR_P,CHR_E,CHR_R,CHR_S,CHR_O,CHR_N,CHR_A,CHR_L,CHR_I,CHR_Z,CHR_E,CHR_SPACE
			defb	CHR_C,CHR_H,CHR_A,CHR_M,CHR_P,CHR_I,CHR_O,CHR_N,CHR_S,CHR_H,CHR_I,CHR_P
			defb	32+64+0,5*32+0,CHR_T,CHR_R,CHR_A,CHR_C,CHR_K,CHR_S,CHR_COLON,CHR_SPACE,CHR_1,CHR_MINUS,CHR_8,CHR_SPACE
			defb	CHR_S,CHR_E,CHR_T,CHR_SPACE,CHR_SPACE,CHR_9,CHR_SPACE,CHR_E,CHR_R,CHR_A,CHR_S,CHR_E,CHR_SPACE
			defb	CHR_SPACE,CHR_K_EN,CHR_SPACE,CHR_D,CHR_O,CHR_N,CHR_E
			defb	32+64+8,3*32+0,CHR_L,CHR_A,CHR_P,CHR_S,CHR_COLON,CHR_SPACE,CHR_1,CHR_MINUS,CHR_5,CHR_SPACE
			defb	CHR_S,CHR_E,CHR_T,CHR_SPACE,CHR_SPACE,CHR_9,CHR_SPACE,CHR_G,CHR_O,CHR_SPACE
			defb	CHR_B,CHR_A,CHR_C,CHR_K,CHR_SPACE,CHR_SPACE,CHR_K_EN,CHR_SPACE,CHR_D,CHR_O,CHR_N,CHR_E
			defb	32+64+8,5*32+0,CHR_S,CHR_C,CHR_O,CHR_R,CHR_E,CHR_COLON,CHR_SPACE,CHR_0,CHR_MINUS,CHR_6,CHR_SPACE
			defb	CHR_S,CHR_E,CHR_T
			defb	32+64+8,6*32+7,CHR_9,CHR_SPACE,CHR_G,CHR_O,CHR_SPACE,CHR_B,CHR_A,CHR_C,CHR_K
			defb	32+64+8,7*32+7,CHR_K_EN,CHR_SPACE,CHR_D,CHR_O,CHR_N,CHR_E
			defb	32+64+8,5*32+21,CHR_F,CHR_I,CHR_R,CHR_S,CHR_T
			defb	32+64+8,6*32+21,CHR_S,CHR_E,CHR_C,CHR_O,CHR_N,CHR_D
			defb	32+64+8,7*32+21,CHR_T,CHR_H,CHR_I,CHR_R,CHR_D
			defb	32+64+16,0*32+21,CHR_L,CHR_O,CHR_S,CHR_E,CHR_R,CHR_EXCL
			defb	32+64+16,1*32+21,CHR_F,CHR_A,CHR_S,CHR_T,CHR_SPACE,CHR_L,CHR_A,CHR_P
			defb	127
mmapsnumber:		defb	32+64+16,3*32+3,CHR_1
			defb	32+64+16,3*32+7,CHR_2
			defb	32+64+16,3*32+11,CHR_3
			defb	32+64+16,3*32+15,CHR_4
			defb	32+64+16,3*32+19,CHR_5
			defb	32+64+16,3*32+23,CHR_6
			defb	32+64+16,3*32+27,CHR_7
			defb	32+64+16,3*32+31,CHR_8
			defb	128+4,128,127	;Green color here

mrecords_fixed:		defb	32+64+0,4*32+8,CHR_F,CHR_A,CHR_S,CHR_T,CHR_SPACE,CHR_L,CHR_A,CHR_P,CHR_SPACE,CHR_R,CHR_E,CHR_C,CHR_O,CHR_R,CHR_D,CHR_S
			defb	32+64+0,6*32+6,CHR_F,CHR_1
			defb	32+64+0,6*32+13,CHR_G,CHR_P,CHR_2
			defb	32+64+0,6*32+19,CHR_K,CHR_A,CHR_R,CHR_T,CHR_S,CHR_SPACE,CHR_SPACE,CHR_J,CHR_U,CHR_N,CHR_I,CHR_O,CHR_R
			defb	32+64+8,0*32+0,CHR_1,CHR_MINUS
			defb	32+64+8,1*32+0,CHR_2,CHR_MINUS
			defb	32+64+8,2*32+0,CHR_3,CHR_MINUS
			defb	32+64+8,3*32+0,CHR_4,CHR_MINUS
			defb	32+64+8,4*32+0,CHR_5,CHR_MINUS
			defb	32+64+8,5*32+0,CHR_6,CHR_MINUS
			defb	32+64+8,6*32+0,CHR_7,CHR_MINUS
			defb	32+64+8,7*32+0,CHR_8,CHR_MINUS
			defb	127

mpers_param:		defb	32+64+8,5*32+31
mpers_points1:		defb	CHR_5
			defb	32+64+8,6*32+31
mpers_points2:		defb	CHR_3
			defb	32+64+8,7*32+31
mpers_points3:		defb	CHR_1
			defb	32+64+16,0*32+31
mpers_points4:		defb	CHR_0
			defb	32+64+16,1*32+31
mpers_pointsf:		defb	CHR_1
			defb	32+64+8,2*32+2
mpers_laps0:		defb	CHR_2
			defb	32+64+8,2*32+6
mpers_laps1:		defb	CHR_2
			defb	32+64+8,2*32+10
mpers_laps2:		defb	CHR_2
			defb	32+64+8,2*32+14
mpers_laps3:		defb	CHR_2
			defb	32+64+8,2*32+18
mpers_laps4:		defb	CHR_2
			defb	32+64+8,2*32+22
mpers_laps5:		defb	CHR_2
			defb	32+64+8,2*32+26
mpers_laps6:		defb	CHR_2
			defb	32+64+8,2*32+30
mpers_laps7:		defb	CHR_2
			defb	127
		
message_credits:	defb	32+64,3*32+9,CHR_A,CHR_SPACE,CHR_G,CHR_A,CHR_M,CHR_E,CHR_SPACE,CHR_M,CHR_A,CHR_D,CHR_E,CHR_SPACE,CHR_B,CHR_Y
			defb	32+64,5*32+3,CHR_C,CHR_O,CHR_D,CHR_E,CHR_SPACE,CHR_AMPER,CHR_SPACE,CHR_T,CHR_R,CHR_A,CHR_C,CHR_K,CHR_S,CHR_COLON,CHR_SPACE,CHR_SPACE
	 		defb	128+64+7,10,CHR_M,CHR_E,CHR_T,CHR_A,CHR_L,CHR_B,CHR_R,CHR_A,CHR_I,CHR_N
			defb	32+64,7*32+3,CHR_G,CHR_R,CHR_A,CHR_P,CHR_H,CHR_I,CHR_C,CHR_S,CHR_COLON
			defb	32+64,7*32+19,128+64+7,10,CHR_M,CHR_E,CHR_T,CHR_A,CHR_L,CHR_B,CHR_R,CHR_A,CHR_I,CHR_N
			defb	32+64+8,0*32+19,128+64+7,9,CHR_K,CHR_E,CHR_N,CHR_D,CHR_R,CHR_O,CHR_O,CHR_C,CHR_K
			defb	32+64+8,1*32+19,128+64+7,6,CHR_A,CHR_N,CHR_J,CHR_U,CHR_E,CHR_L
			defb	32+64+8,3*32+3,CHR_C,CHR_O,CHR_V,CHR_E,CHR_R,CHR_SPACE,CHR_AMPER,CHR_SPACE,CHR_S,CHR_C,CHR_R,CHR_E,CHR_E,CHR_N,CHR_COLON,CHR_SPACE
			defb	128+64+7,9,CHR_K,CHR_E,CHR_N,CHR_D,CHR_R,CHR_O,CHR_O,CHR_C,CHR_K
			defb	32+64+8,5*32+3,CHR_M,CHR_U,CHR_S,CHR_I,CHR_C,CHR_COLON
			defb	32+64+8,5*32+19,128+64+7,6,CHR_R,CHR_I,CHR_S,CHR_K,CHR_E,CHR_J
			defb	32+64+8,6*32+19,128+64+7,3,CHR_W,CHR_Y,CHR_Z
			defb	32+64+16,0*32+3,CHR_B,CHR_E,CHR_T,CHR_A,CHR_T,CHR_E,CHR_S,CHR_T,CHR_I,CHR_N,CHR_G,CHR_COLON
			defb	32+64+16,0*32+19,128+64+6,8,CHR_C,CHR_E,CHR_Z,CHR_SPACE,CHR_T,CHR_E,CHR_A,CHR_M
			defb	32+64+16,2*32+7,CHR_S,CHR_P,CHR_E,CHR_C,CHR_I,CHR_A,CHR_L,CHR_SPACE,CHR_T,CHR_H,CHR_A,CHR_N,CHR_K,CHR_S,CHR_SPACE,CHR_T,CHR_O,CHR_COLON
			defb	32+64+16,3*32+2,128+64+5,12,CHR_S,CHR_E,CHR_R,CHR_G,CHR_E,CHR_Y,CHR_SPACE,CHR_B,CHR_U,CHR_L,CHR_B,CHR_A,CHR_SPACE,CHR_MINUS,CHR_SPACE
			defb	CHR_V,CHR_O,CHR_R,CHR_T,CHR_E,CHR_X,CHR_SPACE,CHR_T,CHR_R,CHR_A,CHR_C,CHR_K,CHR_E,CHR_R
			defb	32+64+16,4*32+3,128+64+5,11,CHR_M,CHR_A,CHR_G,CHR_N,CHR_U,CHR_S,CHR_SPACE,CHR_L,CHR_I,CHR_N,CHR_D,CHR_SPACE,CHR_MINUS,CHR_SPACE
			defb	CHR_E,CHR_X,CHR_O,CHR_M,CHR_I,CHR_Z,CHR_E,CHR_R
			defb	32+64+16,5*32+3,128+64+5,11,CHR_T,CHR_O,CHR_M,CHR_A,CHR_S,CHR_SPACE,CHR_V,CHR_I,CHR_L,CHR_I,CHR_M,CHR_SPACE,CHR_MINUS,CHR_SPACE
			defb	CHR_O,CHR_R,CHR_F,CHR_E,CHR_U,CHR_S
			defb	32+64+16,6*32+5,128+64+5,9,CHR_S,CHR_T,CHR_A,CHR_R,CHR_G,CHR_A,CHR_Z,CHR_E,CHR_R,CHR_SPACE,CHR_MINUS,CHR_SPACE
			defb	CHR_M,CHR_O,CHR_D,CHR_SPACE,CHR_M,CHR_U,CHR_S,CHR_I,CHR_C
			defb	32+64+16,7*32+0,128+0,32
			defb	127				
		
message_replay:		defb	32+64+16,7*32+1,128+7,30,CHR_R,CHR_SPACE,CHR_T,CHR_O,CHR_SPACE,CHR_R,CHR_E,CHR_P,CHR_L,CHR_A,CHR_Y,CHR_SPACE,CHR_MINUS
			defb	CHR_SPACE,CHR_O,CHR_T,CHR_H,CHR_E,CHR_R,CHR_SPACE,CHR_T,CHR_O,CHR_SPACE,CHR_C,CHR_O,CHR_N,CHR_T,CHR_I,CHR_N,CHR_U,CHR_E
			defb	127

mfirst_all:		defb	32+64,2*32+18,128+7,4,CHR_R,CHR_A,CHR_C,CHR_E,32+64,5*32+17,128+7,6
mfirst_nlaps:		defb	CHR_0,CHR_SPACE,CHR_L,CHR_A,CHR_P,CHR_S
			defb	127
mfirst_play:		defb	32+64,3*32+17,128+7,6
mfirst_nrace:		defb	CHR_0,CHR_SPACE,CHR_O,CHR_F,CHR_SPACE
mfirst_total:		defb	CHR_0
			defb	127
mfirst_replay:		defb	32+64,3*32+17,128+4,6,CHR_R,CHR_E,CHR_P,CHR_L,CHR_A,CHR_Y
			defb	127